<?php

namespace RageKings\KingWalletApi\Tests\Unit\Requests\V2;

use RageKings\KingWalletApi\Enums\RequestState;
use RageKings\KingWalletApi\Requests\V2\GetOrder;
use RageKings\KingWalletApi\Responses\V2\Order;
use RageKings\KingWalletApi\Tests\IntegrationTest;

class GetOrderTest extends IntegrationTest
{
    /**
     * @return void
     * @throws \Throwable
     */
    public function test_request(): void
    {
        $mockClient = $this->buildSaloonMockClient([
            $this->getFakeResponseForV2Order(RequestState::PAYED)
        ]);

        $request = new GetOrder('2168075008115');
        $request->withQueryAuth('api_key', $this->walletService->getApiToken());

        $response = $this->walletService->send($request, $mockClient);

        $this->assertInstanceOf(Order::class, $response->dto());
    }
}
