<?php

namespace RageKings\KingWalletApi\Tests\Unit\Requests\V1;

use RageKings\KingWalletApi\Enums\RequestState;
use RageKings\KingWalletApi\Requests\V1\CreateOrder;
use RageKings\KingWalletApi\Responses\V1\Order;
use RageKings\KingWalletApi\Tests\IntegrationTest;

class CreateOrderTest extends IntegrationTest
{
    /**
     * @return void
     * @throws \Throwable
     */
    public function test_request(): void
    {
        $mockClient = $this->buildSaloonMockClient([
            $this->getFakeResponseForV1Order(RequestState::PAYED)
        ]);

        $request = new CreateOrder('500', 'ccard');
        $request->withQueryAuth('api_key', $this->walletService->getApiToken());

        $response = $this->walletService->send($request, $mockClient);

        $this->assertInstanceOf(Order::class, $response->dto());
    }
}
