<?php

namespace RageKings\KingWalletApi\Responses\V2;

use Carbon\Carbon;
use RageKings\KingWalletApi\Casters\CarbonCaster;
use RageKings\KingWalletApi\Casters\RequestStateCaster;
use RageKings\KingWalletApi\Enums\RequestState;
use Spatie\DataTransferObject\Attributes\CastWith;
use Spatie\DataTransferObject\Casters\ArrayCaster;
use Spatie\DataTransferObject\DataTransferObject;

class Order extends DataTransferObject
{
    public string $uuid;

    #[CastWith(RequestStateCaster::class)]
    public RequestState $state;

    public float $sum_amount;

    public string $sum_currency;

    public ?string $comment;

    #[CastWith(CarbonCaster::class)]
    public ?Carbon $wait_till;

    #[CastWith(CarbonCaster::class)]
    public Carbon $created_at;

    public string $to;

    public string $direction;

    public ?array $extra;

    #[CastWith(ArrayCaster::class, Payment::class)]
    public array $payments;


    /**
     * @throws \Spatie\DataTransferObject\Exceptions\UnknownProperties
     */
    public static function fromJson(string $json): self
    {
        $data = json_decode($json, true);
        return new self($data);
    }
}
