<?php

namespace RageKings\KingWalletApi\Responses\V1;

use Carbon\Carbon;
use RageKings\KingWalletApi\Casters\CarbonCaster;
use RageKings\KingWalletApi\Casters\RequestStateCaster;
use RageKings\KingWalletApi\Enums\RequestState;
use Spatie\DataTransferObject\Attributes\CastWith;
use Spatie\DataTransferObject\DataTransferObject;

class Order extends DataTransferObject
{
    public string $request_id;

    #[CastWith(RequestStateCaster::class)]
    public RequestState $status;

    public ?string $num;

    public float $sum;

    public ?string $comment;

    #[CastWith(CarbonCaster::class)]
    public Carbon $date;

    #[CastWith(CarbonCaster::class)]
    public ?Carbon $wait_till;

    public string $payment_method;

    /**
     * @throws \Spatie\DataTransferObject\Exceptions\UnknownProperties
     */
    public static function fromJson(string $json): self
    {
        $data = json_decode($json, true);
        return new self($data);
    }
}
