<?php

namespace RageKings\KingWalletApi\Requests\V1;

use RageKings\KingWalletApi\Responses\V1\Order;
use Saloon\Contracts\Body\HasBody;
use Saloon\Contracts\Response;
use Saloon\Enums\Method;
use Saloon\Traits\Body\HasJsonBody;

class CreateOrder extends ApiRequest implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::POST;

    /**
     * Создание заявки на пополнение
     *
     * @param float $sum Сумма заявки
     * @param string $payment_method Метод оплаты (ccard, qiwi, sim, yandex)
     * @param string|null $sub_type
     * @param string|null $comment
     * @param array $tags Список тегов заявки
     */
    public function __construct(float $sum, string $payment_method, string $sub_type = null, string $comment = null, array $tags = [], string $callbackUrl = null)
    {
        $data = [
            'sum'           => $sum,
            'payment_method'=> $payment_method,
            'tags'          => $tags
        ];

        if ($sub_type)
            $data['sub_type'] = $sub_type;

        if ($comment)
            $data['comment'] = $comment;

        if ($callbackUrl)
            $data['callback_url'] = $callbackUrl;

        $this->body()->set($data);
    }

    /**
     * @inheritDoc
     */
    public function resolveEndpoint(): string
    {
        return 'api/v1/request';
    }

    /**
     * @param \Saloon\Contracts\Response $response
     * @return \RageKings\KingWalletApi\Responses\V1\Order
     * @throws \Spatie\DataTransferObject\Exceptions\UnknownProperties
     */
    public function createDtoFromResponse(Response $response): Order
    {
        return new Order($response->json('request'));
    }
}
