<?php

namespace RageKings\KingWalletApi;

use Illuminate\Support\ServiceProvider;

class KingWalletProvider extends ServiceProvider
{
    public function boot(): void
    {
        $this->publishes([
            __DIR__.'/../config/king-wallet.php' => config_path('king-wallet.php')
        ], 'king-wallet');
    }

    public function register()
    {
        $this->mergeConfigFrom(
            __DIR__.'/../config/king-wallet.php', 'king-wallet'
        );

        $this->app->singleton(KingWalletService::class, function () {
            return new KingWalletService(config('king-wallet.token'), config('king-wallet.url'));
        });
    }
}