<?php

namespace RageKings\KingWalletApi\Enums\Payment;

enum PaymentState: string
{
    case STATE_NEW         = 'new';
    case STATE_SUCCESS     = 'success';
    case STATE_ERROR       = 'error';
    case STATE_ACCEPTED    = 'accepted';       // Для исходящих платежей, которые прошли все этапы формирования платежа, но сторонний сервис пока не подтвердил платеж
    case STATE_CANCELED    = 'canceled';       // Для отмененных или просроченных платежей
    case STATE_IN_PROGRESS = 'in_progress';    // Для исходящих платежей, находящихся в состоянии выполнения
    case STATE_REFUNDED    = 'refunded';       // Для систем, которые успешный платеж могут перевести в рефанд. Использовать только при крайней необходимости
    case STATE_UNCONFIRMED = 'unconfirmed';    // Для криптовалюты, когда платеж проведен, но не имеет достаточных подтверждений
}