<?php

namespace RageKings\KingWalletApi\Authenticators;

use RageKings\KingWalletApi\Contracts\WithV1Auth;
use RageKings\KingWalletApi\Contracts\WithV2Auth;
use Saloon\Contracts\Authenticator;
use Saloon\Contracts\PendingRequest;

class LegacyAuthenticator implements Authenticator
{
    protected string $apiToken;

    public function __construct(string $apiToken)
    {
        $this->apiToken = $apiToken;
    }

    public function set(PendingRequest $pendingRequest): void
    {
        if ($pendingRequest->getRequest() instanceof WithV2Auth)
            $pendingRequest->headers()->add('Authorization', $this->apiToken);

        if ($pendingRequest->getRequest() instanceof WithV1Auth)
            $pendingRequest->query()->add('api_key', $this->apiToken);
    }
}
