<?php

namespace RageKings\KingWalletApi\Tests;

use RageKings\KingWalletApi\Enums\RequestState;
use Saloon\Http\Faking\MockClient;
use Saloon\Http\Faking\MockResponse;

trait WithResponseFaker
{
    /**
     * @param array<\Saloon\Http\Faking\MockResponse|\Closure> $response
     * @return \Saloon\Http\Faking\MockClient
     * @throws \Throwable
     */
    public function buildSaloonMockClient(array $response): MockClient
    {
        return new MockClient($response);
    }

    /**
     * Генерация фейкового ответа от King Wallet
     *
     * @param \RageKings\KingWalletApi\Enums\RequestState $status
     * @return \Saloon\Http\Faking\MockResponse
     */
    protected function getFakeResponseForV1Order(RequestState $status, array $orderAttributes = []): MockResponse
    {
        $orderData = [
            'request' => array_merge([
                'request_id'=> '324324324',
                'status'    => $status->value,
                'num'       => '1000200030004000',
                'sum'       => 2,
                'payment_method' => 'ccard',
                'comment'   => null,
                'wait_till' => '2023-06-06T08:57:22.000000Z',
                'date'      => '2022-06-06T08:57:22.000000Z'
            ], $orderAttributes)
        ];

        return MockResponse::make($orderData, 200);
    }

    /**
     * Генерация фейкового ответа от King Wallet
     *
     * @param \RageKings\KingWalletApi\Enums\RequestState $status
     * @return \Saloon\Http\Faking\MockResponse
     */
    protected function getFakeResponseForV2Order(RequestState $status): MockResponse
    {
        $orderData = [
            'data' => [
                'uuid'          => '9e5917c1-85b0-42a1-95a8-4529faa038b1',
                'state'         => $status->value,
                'sum_amount'    => 2,
                'sum_currency'  => 'BTC',
                'comment'       => null,
                'wait_till'     => '2023-06-06T08:57:22.000000Z',
                'created_at'    => '2022-06-06T08:57:22.000000Z',
                'to'            => 'bc1qp3n953n4gttu808m8xg3zn4jshaexlj5xxg9ww',
                'direction'     => 'btc_btc',
                'extra' => [
                    'memo'      => 91713,
                    'time'      => 1654505842,
                    'expires'   => 31536000,
                    'uri'       => 'bitcoin:bc1qp3n953n4gttu808m8xg3zn4jshaexlj5xxg9ww?amount=0.2&message=91713&time=1654505842&exp=31536000'
                ],
                "payments" => [
                    [
                        "title" => "test",
                        "transaction_id" => "test",
                        "direction" => 0,
                        "sum_amount" => 3453.56,
                        "sum_currency" => "RUB",
                        "state" => "success",
                        "created_at" => "2022-07-13T10:32:27.000000Z",
                        "request_id" => 3435,
                        "destination" => [
                            "id" => 565,
                            "type" => "btc"
                        ]
                    ]
                ]
            ]
        ];

        return MockResponse::make($orderData, 200);
    }
}
