<?php

namespace RageKings\KingWalletApi\Tests\Unit\Requests\V2;

use RageKings\KingWalletApi\Enums\RequestState;
use RageKings\KingWalletApi\Requests\V2\CreateWithdrawOrder;
use RageKings\KingWalletApi\Responses\V2\Order;
use RageKings\KingWalletApi\Tests\IntegrationTest;

class CreateWithdrawalOrderTest extends IntegrationTest
{
    /**
     * @return void
     * @throws \Throwable
     */
    public function test_request(): void
    {
        $mockClient = $this->buildSaloonMockClient([
            $this->getFakeResponseForV2Order(RequestState::PAYED)
        ]);

        $request = new CreateWithdrawOrder(0.1, 'BTC', 'BTC', 'BTC', '0x0');
        $request->withQueryAuth('api_key', $this->walletService->getApiToken());

        $response = $this->walletService->send($request, $mockClient);

        $this->assertInstanceOf(Order::class, $response->dto());
    }
}
