<?php

namespace RageKings\KingWalletApi\Tests;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Orchestra\Testbench\TestCase;
use RageKings\KingWalletApi\KingWalletProvider;
use RageKings\KingWalletApi\KingWalletService;

abstract class IntegrationTest extends TestCase
{
    use RefreshDatabase, WithResponseFaker;

    const fake_entity_count = 5;

    protected KingWalletService $walletService;

    /**
     * Setup the test case.
     *
     * @return void
     */
    public function setUp(): void
    {
        parent::setUp();

        $this->walletService = app()->get(KingWalletService::class);
    }

    protected function getPackageProviders($app): array
    {
        return [
            KingWalletProvider::class,
        ];
    }

}