<?php

namespace RageKings\KingWalletApi\Responses\V2;

use Carbon\Carbon;
use RageKings\KingWalletApi\Casters\CarbonCaster;
use RageKings\KingWalletApi\Casters\Payment\PaymentDirectionCaster;
use RageKings\KingWalletApi\Casters\Payment\PaymentStateCaster;
use RageKings\KingWalletApi\Enums\Payment\PaymentDirection;
use RageKings\KingWalletApi\Enums\Payment\PaymentState;
use RageKings\KingWalletApi\Responses\V2\Payment\Destination;
use Spatie\DataTransferObject\Attributes\CastWith;
use Spatie\DataTransferObject\DataTransferObject;

class Payment extends DataTransferObject
{
    public string $title;

    public ?string $transaction_id;

    #[CastWith(PaymentDirectionCaster::class)]
    public PaymentDirection $direction;

    public float $sum_amount;

    public string $sum_currency;

    #[CastWith(PaymentStateCaster::class)]
    public PaymentState $state;

    #[CastWith(CarbonCaster::class)]
    public Carbon $created_at;

    public ?int $request_id;

    public ?Destination $destination;
}