<?php

namespace RageKings\KingWalletApi\Requests\V2;

use RageKings\KingWalletApi\Responses\V2\Order;
use Saloon\Contracts\Body\HasBody;
use Saloon\Contracts\Response;
use Saloon\Enums\Method;
use Saloon\Traits\Body\HasJsonBody;

class CreateWithdrawOrder extends ApiRequest implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::POST;

    /**
     * Создание заявки на вывод
     *
     * @param float $sum_amount
     * @param string $sum_currency
     * @param string $from_type
     * @param string $to_type
     * @param string $to_account
     * @param array $tags Список тегов заявки
     */
    public function __construct(float $sum_amount, string $sum_currency, string $from_type, string $to_type, string $to_account, array $tags = [])
    {
        $data = [
            'sum_amount'        => $sum_amount,
            'sum_currency'      => $sum_currency,
            'cashout_model_type'=> $from_type,
            'dst_model_type'    => $to_type,
            'dst_model_id'      => $to_account,
            'tags'              => $tags
        ];

        $this->body()->set($data);
    }

    /**
     * @inheritDoc
     */
    public function resolveEndpoint(): string
    {
        return 'api/v2/request';
    }

    /**
     * @param \Saloon\Contracts\Response $response
     * @return \RageKings\KingWalletApi\Responses\V2\Order
     * @throws \Spatie\DataTransferObject\Exceptions\UnknownProperties
     */
    public function createDtoFromResponse(Response $response): Order
    {
        return new Order($response->json('data'));
    }
}
