<?php

namespace RageKings\KingWalletApi\Requests\V1;

use RageKings\KingWalletApi\Responses\V1\Order;
use Saloon\Contracts\Response;
use Saloon\Enums\Method;

class GetOrder extends ApiRequest
{
    protected Method $method = Method::GET;

    protected string $order_id;

    public function __construct(string $order_id)
    {
        $this->order_id = $order_id;
    }

    public function resolveEndpoint(): string
    {
        return 'api/v1/request/' . $this->order_id;
    }

    /**
     * @param \Saloon\Contracts\Response $response
     * @return \RageKings\KingWalletApi\Responses\V1\Order
     * @throws \Spatie\DataTransferObject\Exceptions\UnknownProperties
     */
    public function createDtoFromResponse(Response $response): Order
    {
        return new Order($response->json('request'));
    }
}
