<?php

namespace RageKings\KingWalletApi;

use RageKings\KingWalletApi\Authenticators\LegacyAuthenticator;
use RageKings\KingWalletApi\Http\Middleware\HttpTracingMiddleware;
use Saloon\Contracts\Authenticator;
use Saloon\Contracts\MockClient;
use Saloon\Contracts\Request;
use Saloon\Contracts\Response;
use Saloon\Http\Connector;
use Saloon\Http\Senders\GuzzleSender;

class KingWalletService extends Connector
{
    protected string $baseUrl;

    protected string $apiToken;

    /**
     * @param string $apiToken
     * @param string $baseUrl
     */
    public function __construct(string $apiToken, string $baseUrl)
    {
        $this->baseUrl = $baseUrl;
        $this->apiToken = $apiToken;

        /** @var GuzzleSender $sender */
        $sender = $this->sender();
        $sender->addMiddleware(HttpTracingMiddleware::trace());
    }

    /**
     * @param \Saloon\Contracts\Request $request
     * @param \Saloon\Contracts\MockClient|null $mockClient
     * @return \Saloon\Contracts\Response
     * @throws \ReflectionException
     * @throws \Saloon\Exceptions\InvalidResponseClassException
     * @throws \Saloon\Exceptions\PendingRequestException
     */
    public function send(Request $request, MockClient $mockClient = null): Response
    {
        return parent::send($request, $mockClient);
    }

    public function getApiToken(): string
    {
        return $this->apiToken;
    }


    public function resolveBaseUrl(): string
    {
        return $this->baseUrl;
    }

    protected function defaultHeaders(): array
    {
        return [
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
        ];
    }

    protected function defaultConfig(): array
    {
        return [
            'timeout' => 30
        ];
    }

    protected function defaultAuth(): ?Authenticator
    {
        return new LegacyAuthenticator($this->apiToken);
    }
}
