<?php

namespace RageKings\KingPayApi\Tests;

use Saloon\Http\Faking\MockClient;
use Saloon\Http\Faking\MockResponse;

trait WithResponseFaker
{
    /**
     * @param array<\Saloon\Http\Faking\MockResponse|\Closure> $response
     * @return \Saloon\Http\Faking\MockClient
     * @throws \Throwable
     */
    public function buildSaloonMockClient(array $response): MockClient
    {
        return new MockClient($response);
    }

    protected function getFakeResponseForCreateInvoice(array $attributes = []): MockResponse
    {
        $data = [
            'data' => [
                'id' => '4454545',
                'customer_invoice_id' => 'test',
                'project_id' => 'test',
                'title' => 'test',
                'comment' => 'comment',
                'sum' => [
                    'value' => 'test',
                    'money' => [
                        'amount' => 5656.67,
                        'currency' => 'RUB'
                    ]
                ],
                'state' => 'new',
                'invoice_url' => 'test',
                'successUrl' => 'test',
                'failUrl' => 'test',
                'expired_at' => now()->toString(),
                'created_at' => now()->toString(),
            ]
        ];

        return MockResponse::make($data, 200);
    }
}
