<?php

namespace RageKings\KingPayApi\Tests\Unit\Requests\Invoice;

use RageKings\KingPayApi\Requests\Invoice\CreateRequest;
use RageKings\KingPayApi\Responses\Invoice\Invoice;
use RageKings\KingPayApi\Tests\IntegrationTest;

class CreateRequestTest extends IntegrationTest
{
    public function test_request(): void
    {
        $mockClient = $this->buildSaloonMockClient([
            $this->getFakeResponseForCreateInvoice()
        ]);

        $request = new CreateRequest('title', 'comment', 1789.56, 'RUB');

        $response = $this->kingPayApiService->send($request, $mockClient);

        $this->assertInstanceOf(Invoice::class, $response->dto());
    }
}