<?php

namespace RageKings\KingPayApi\Responses\Invoice;

use Illuminate\Support\Carbon;
use RageKings\KingPayApi\Casters\CarbonCaster;
use RageKings\KingPayApi\Responses\Invoice\CurrentOrder\Method;
use RageKings\KingPayApi\Responses\Invoice\CurrentOrder\PaymentDetails;
use Spatie\DataTransferObject\Attributes\CastWith;
use Spatie\DataTransferObject\DataTransferObject;

class InvoiceOrder extends DataTransferObject
{
    /**
     * Уникальный ID заявки в нашей системе. Формируется в формате UUID
     * @var string
     */
    public string $uuid;

    /**
     * Метод оплаты заявки
     * @var Method
     */
    public Method $method;

    /**
     * Детали заявки для ее оплаты
     * @var PaymentDetails
     */
    public PaymentDetails $payment_details;

    /**
     * Дата окончания оплаты заявки в формате ATOM
     * @var Carbon|null
     */
    #[CastWith(CarbonCaster::class)]
    public ?Carbon $expired_at;

    /**
     * Дата создания заявки в формате ATOM
     * @var Carbon
     */
    #[CastWith(CarbonCaster::class)]
    public Carbon $created_at;
}