<?php

namespace RageKings\KingPayApi\Requests\Invoice;

use RageKings\KingPayApi\Responses\Invoice\InvoicePaymentMethods;
use Saloon\Http\Response;
use Saloon\Enums\Method;
use Saloon\Http\Request;

class GetPaymentMethodsRequest extends Request
{
    protected Method $method = Method::GET;

    /**
     * Уникальный ID счета системе. В формате UUID
     * @var string
     */
    protected string $invoice_id;

    public function __construct(string $invoice_id)
    {
        $this->invoice_id = $invoice_id;
    }

    /**
     * @inheritDoc
     */
    public function resolveEndpoint(): string
    {
        return "api/invoice/{$this->invoice_id}/getPaymentMethods";
    }

    /**
     * @param Response $response
     * @return InvoicePaymentMethods
     * @throws \JsonException
     * @throws \Spatie\DataTransferObject\Exceptions\UnknownProperties
     */
    public function createDtoFromResponse(Response $response): InvoicePaymentMethods
    {
        return new InvoicePaymentMethods($response->json());
    }
}