<?php

namespace RageKings\KingPayApi\Requests\Invoice;

class CreateWithOrderRequest extends CreateRequest
{
    /**
     * Код метода оплаты (примеры: ccard, btc, usdt)
     * @var string
     */
    protected string $invoicePaymentMethod;

    public function setInvoicePaymentMethod(string $method): void
    {
        $this->invoicePaymentMethod = $method;
    }

    /**
     * @inheritDoc
     */
    public function resolveEndpoint(): string
    {
        return "api/invoice/withOrder/{$this->invoicePaymentMethod}";
    }
}