<?php

namespace RageKings\KingPayApi\Requests\Invoice;

use RageKings\KingPayApi\Responses\Invoice\Invoice;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;
use Saloon\Traits\Body\HasJsonBody;

class CreateRequest extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::POST;

    public function __construct(
        string $title, // Заголовок счет-фактуры
        string $comment, // Описание счет-фактуры
        float $amount, // Сумма, на которую будет происходить пополнение баланса продавца
        string $currency, // Валюта пополнения
        string $customer_invoice_id = null, // Уникальный ID счета для продавца. Это может быть номер заказа в системе продавца.
        string $project_id = null, // ID проекта для которого создается счет-фактура.
        string $expired_at = null, // Срок действия счет-фактуры в формате ATOM. Если значение не указано, то счет-фактура будет создана со сроком действия 1 час
        string $notifyUrl = null, // URL для принятия HTTP-уведомлений с информацией о счет-фактуре. Платформа отсылает POST-запрос на указанный URL с объектом
        string $successUrl = null, // URL на который произойдет редирект пользователя после удачной оплаты счет-фактуры.
        string $failUrl = null, // URL на который произойдет редирект пользователя, если счет-фактура была отменена или истек ее срок действия.
        array $tags = null // Теги которые будут присвоены счёт-фактуре
    )
    {
        $this->body()->set(array_filter([
            'title' => $title,
            'comment' => $comment,
            'amount' => $amount,
            'currency' => $currency,
            'customer_invoice_id' => $customer_invoice_id,
            'project_id' => $project_id,
            'expired_at' => $expired_at,
            'notifyUrl' => $notifyUrl,
            'successUrl' => $successUrl,
            'failUrl' => $failUrl,
            'tags' => $tags
        ]));
    }

    /**
     * @inheritDoc
     */
    public function resolveEndpoint(): string
    {
        return 'api/invoice';
    }

    /**
     * @param Response $response
     * @return Invoice
     * @throws \JsonException
     * @throws \Spatie\DataTransferObject\Exceptions\UnknownProperties
     */
    public function createDtoFromResponse(Response $response): Invoice
    {
        return new Invoice($response->json('data'));
    }
}