<?php

namespace RageKings\KingPayApi\Requests\Invoice;

use RageKings\KingPayApi\Responses\Invoice\Invoice;
use RageKings\KingPayApi\Responses\Invoice\InvoiceOrder;
use Saloon\Contracts\Body\HasBody;
use Saloon\Http\Response;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class CreateOrderRequest extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::POST;

    /**
     * Уникальный ID счета системе. В формате UUID
     * @var string
     */
    protected string $invoice_id;

    /**
     * Код метода оплаты (примеры: ccard, btc, usdt)
     * @var string
     */
    protected string $invoicePaymentMethod;

    public function __construct(string $invoice_id, string $invoicePaymentMethod)
    {
        $this->invoice_id = $invoice_id;
        $this->invoicePaymentMethod = $invoicePaymentMethod;
    }

    /**
     * @inheritDoc
     */
    public function resolveEndpoint(): string
    {
        return "api/invoice/{$this->invoice_id}/createOrder/{$this->invoicePaymentMethod}";
    }

    /**
     * @param Response $response
     * @return InvoiceOrder
     * @throws \JsonException
     * @throws \Spatie\DataTransferObject\Exceptions\UnknownProperties
     */
    public function createDtoFromResponse(Response $response): InvoiceOrder
    {
        return new InvoiceOrder($response->json('data'));
    }
}