<?php

namespace RageKings\KingPayApi\Requests\Invoice;

use RageKings\KingPayApi\Responses\Invoice\Invoice;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;
use Saloon\Traits\Body\HasJsonBody;

class ConfirmRequest extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::POST;

    /**
     * Уникальный ID счета системе. В формате UUID
     * @var string
     */
    protected string $invoice_id;

    public function __construct(string $invoice_id)
    {
        $this->invoice_id = $invoice_id;
    }

    /**
     * @inheritDoc
     */
    public function resolveEndpoint(): string
    {
        return "api/invoice/{$this->invoice_id}/confirm";
    }

    /**
     * @param Response $response
     * @return Invoice
     * @throws \JsonException
     * @throws \Spatie\DataTransferObject\Exceptions\UnknownProperties
     */
    public function createDtoFromResponse(Response $response): Invoice
    {
        return new Invoice($response->json('data'));
    }
}