<?php

namespace RageKings\KingPayApi;

use RageKings\KingPayApi\Http\Middleware\HttpTracingMiddleware;
use Saloon\Contracts\Authenticator;
use Saloon\Http\Auth\TokenAuthenticator;
use Saloon\Http\Connector;
use Saloon\Http\Faking\MockClient;
use Saloon\Http\Request;
use Saloon\Http\Response;
use Saloon\Http\Senders\GuzzleSender;

class KingPayApiService extends Connector
{
    protected string $baseUrl;

    protected string $apiToken;

    /**
     * @param string $apiToken
     * @param string $baseUrl
     */
    public function __construct(string $apiToken, string $baseUrl)
    {
        $this->baseUrl = $baseUrl;
        $this->apiToken = $apiToken;

        /** @var GuzzleSender $sender */
        $sender = $this->sender();
        $sender->addMiddleware(HttpTracingMiddleware::trace());
    }

	public function send(Request $request, MockClient $mockClient = null, callable $handleRetry = null): Response
	{
		return parent::send($request, $mockClient);
	}

	public function getApiToken(): string
    {
        return $this->apiToken;
    }


    public function resolveBaseUrl(): string
    {
        return $this->baseUrl;
    }

    protected function defaultHeaders(): array
    {
        return [
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
        ];
    }

    protected function defaultConfig(): array
    {
        return [
            'timeout' => 30
        ];
    }

    protected function defaultAuth(): ?Authenticator
    {
        return new TokenAuthenticator($this->getApiToken());
    }
}
