<?php

namespace RageKings\KingPayApi;

use Illuminate\Support\ServiceProvider;

class KingPayApiProvider extends ServiceProvider
{
    public function boot(): void
    {
        $this->publishes([
            __DIR__.'/../config/king-pay-api.php' => config_path('king-pay-api.php')
        ], 'king-pay-api');
    }

    public function register()
    {
        $this->mergeConfigFrom(
            __DIR__.'/../config/king-pay-api.php', 'king-pay-api'
        );

        $this->app->singleton(KingPayApiService::class, function () {
            return new KingPayApiService(config('king-pay-api.token'), config('king-pay-api.url'));
        });
    }
}