<?php


namespace Astreya\WalletUtils\Dto\Response;

use Astreya\WalletUtils\Dto\PaymentData;
use InvalidArgumentException;
use Psr\Http\Message\ResponseInterface;

class FetchedPayments
{
    const SUCCESS = 'success';
    const FAILED = 'failed';

    const RESULTS = [self::SUCCESS, self::FAILED];

    private string $result;

    private string $message = '';

    private array $payments;

    /**
     * @return string
     */
    public function getResult(): string
    {
        return $this->result;
    }

    /**
     * @param string $result
     * @throws \InvalidArgumentException
     */
    private function setResult(string $result): void
    {
        if (true !== in_array($result, self::RESULTS))
            throw new InvalidArgumentException("$result does not valid result");

        $this->result = $result;
    }

    public function getPayments() : array
    {
        return $this->payments;
    }

    /**
     * @return string
     */
    public function getMessage(): string
    {
        return $this->message;
    }

    /**
     * @param string $message
     */
    public function setMessage(string $message): void
    {
        $this->message = $message;
    }

    /**
     * Создание объекта из ответа на Http-запрос
     *
     * @param \Psr\Http\Message\ResponseInterface $response
     * @return static
     */
    static function createFromHttpResponse(ResponseInterface $response) : self
    {
        $json = (string)$response->getBody();
        $data = json_decode($json, true);
        return self::createFromArray($data);
    }

    /**
     * Создание объекта из ответа на Http-запрос
     *
     * @param string $json
     * @return static
     */
    static function createFromJson(string $json) : self
    {
        $data = json_decode($json, true);
        return self::createFromArray($data);
    }

    /**
     * Создание обьекта из массива
     *
     * @param array $data
     * @return static
     */
    static function createFromArray(array $data) : self
    {
        $ob = new self();
        $ob->setResult($data['result']);

        if (isset($data['message']))
            $ob->setMessage($data['message']);

        $ob->payments = [];

        foreach($data['data'] as $payment) {
            $ob->payments[] = PaymentData::createFromArray($payment);
        }

        return $ob;
    }

    public function toArray() : array
    {
        return [
            'result'    => $this->getResult(),
            'message'   => $this->getMessage(),
            'data'      => array_map(function(PaymentData $paymentData){
                return $paymentData->toArray();
            }, $this->getPayments())
        ];
    }
}
