<?php


namespace Astreya\WalletUtils\Dto;


use Carbon\Carbon;
use InvalidArgumentException;

/**
 * Class QueuedTask
 *
 * @package App\Dto\Response
 */
class QueuedTaskData
{
    const TYPE_FETCH_BALANCE    = 'fetch_balance';
    const TYPE_FETCH_PAYMENTS   = 'fetch_payments';
    const TYPE_FETCH_PROFILE    = 'fetch_profile';
    const TYPE_CREATE_PAYMENT   = 'create_payment';
    const TYPE_SIGN_UP          = 'sign_up';
    const TYPE_SIGN_IN          = 'sign_in';
    const TYPE_PREPARATION      = 'preparation';

    const STATE_IN_QUEUE        = 'in_queue';
    const STATE_IN_PROGRESS     = 'in_progress';
    const STATE_DONE            = 'done';
    const STATE_FAILED          = 'failed';
    const STATE_REJECTED        = 'rejected';

    const STATES = [
        self::STATE_IN_QUEUE,
        self::STATE_IN_PROGRESS,
        self::STATE_DONE,
        self::STATE_FAILED,
        self::STATE_REJECTED,
    ];

    const TYPES = [
        self::TYPE_FETCH_BALANCE,
        self::TYPE_FETCH_PAYMENTS,
        self::TYPE_FETCH_PROFILE,
        self::TYPE_CREATE_PAYMENT,
        self::TYPE_PREPARATION,
        self::TYPE_SIGN_UP,
        self::TYPE_SIGN_IN
    ];

    private string $id;

    private string $type;

    private string $state = self::STATE_IN_QUEUE;

    private array $context = [];

    private array $result = [];

    private Carbon $created_at;

    private Carbon $updated_at;

    /**
     * @return string
     */
    public function getId(): string
    {
        return $this->id;
    }

    /**
     * @param string $id
     */
    public function setId(string $id): void
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @param string $type
     */
    public function setType(string $type): void
    {

        if (true !== in_array($type, self::TYPES))
            throw new InvalidArgumentException("$type does not valid type");

        $this->type = $type;
    }

    /**
     * @return string
     */
    public function getState(): string
    {
        return $this->state;
    }

    /**
     * @param string $state
     */
    public function setState(string $state): void
    {
        if (true !== in_array($state, self::STATES))
            throw new InvalidArgumentException("$state does not valid state");

        $this->state = $state;
    }

    /**
     * @return array
     */
    public function getContext(): array
    {
        return $this->context;
    }

    /**
     * @param array $context
     */
    public function setContext(array $context): void
    {
        $this->context = $context;
    }

    /**
     * @return array
     */
    public function getResult(): array
    {
        return $this->result;
    }

    /**
     * @param array $result
     */
    public function setResult(array $result): void
    {
        $this->result = $result;
    }

    /**
     * @return \Illuminate\Support\Carbon
     */
    public function getCreatedAt(): Carbon
    {
        return $this->created_at;
    }

    /**
     * @param \Illuminate\Support\Carbon|string $created_at
     */
    public function setCreatedAt($created_at): void
    {
        if (is_string($created_at))
            $created_at = Carbon::parse($created_at);

        $this->created_at = $created_at;
    }

    /**
     * @return \Illuminate\Support\Carbon
     */
    public function getUpdatedAt(): Carbon
    {
        return $this->updated_at;
    }

    /**
     * @param \Illuminate\Support\Carbon|string $updated_at
     */
    public function setUpdatedAt($updated_at): void
    {
        if (is_string($updated_at))
            $updated_at = Carbon::parse($updated_at);

        $this->updated_at = $updated_at;
    }

    /**
     * @param array $data
     * @return static
     */
     public static function createFromArray(array $data) : self
     {
         $ob = new self();

         $ob->setId($data['id']);
         $ob->setType($data['type']);

         if (isset($data['context']))
             $ob->setContext($data['context']);

         if (isset($data['result']))
             $ob->setResult($data['result']);

         if (isset($data['state']))
             $ob->setState($data['state']);

         if (isset($data['created_at']))
             $ob->setCreatedAt($data['created_at']);
         else
             $ob->setCreatedAt(Carbon::now());

         if (isset($data['updated_at']))
             $ob->setUpdatedAt($data['updated_at']);
         else
             $ob->setUpdatedAt(Carbon::now());

         return $ob;
     }

     public function toArray() : array
     {
         return [
             'id'           => $this->getId(),
             'type'         => $this->getType(),
             'state'        => $this->getState(),
             'created_at'   => $this->getCreatedAt()->format('Y-m-d\TH:i:sP'),
             'updated_at'   => $this->getUpdatedAt()->format('Y-m-d\TH:i:sP'),
             'context'      => $this->getContext(),
             'result'       => $this->getResult()
         ];
     }
}
