<?php


namespace Astreya\WalletUtils\Dto\RequestBody;


use Astreya\WalletUtils\Dto\WalletData;
use Astreya\WalletUtils\Dto\WalletMessage;

class ProcessMessageBody
{
    private WalletData $wallet;

    private WalletMessage $message;

    protected array $options;

    /**
     * @param WalletData $wallet
     * @param WalletMessage $message
     * @param array $options
     */
    public function __construct(WalletData $wallet, WalletMessage $message, array $options = [])
    {
        $this->setWallet($wallet);
        $this->setMessage($message);
        $this->setOptions($options);
    }

    /**
     * @return \Astreya\WalletUtils\Dto\WalletData
     */
    public function getWallet(): WalletData
    {
        return $this->wallet;
    }

    /**
     * @param \Astreya\WalletUtils\Dto\WalletData $wallet
     */
    public function setWallet(WalletData $wallet): void
    {
        $this->wallet = $wallet;
    }

    /**
     * @return \Astreya\WalletUtils\Dto\WalletMessage
     */
    public function getMessage(): WalletMessage
    {
        return $this->message;
    }

    /**
     * @param \Astreya\WalletUtils\Dto\WalletMessage $message
     */
    public function setMessage(WalletMessage $message): void
    {
        $this->message = $message;
    }

    public function getOptions(): array
    {
        return $this->options;
    }

    public function setOptions(array $options): void
    {
        $this->options = $options;
    }

    public function toArray(): array
    {
        return [
            "wallet"    => $this->getWallet()->toArray(),
            "message"   => $this->getMessage()->toArray(),
            "options"   => $this->getOptions()
        ];
    }


}