<?php


namespace Astreya\WalletUtils\Dto;


class WalletData
{
    private string $login;

    private string $password;

    private string $phone_number;

    private string $email;

    private array $extra = [];

    /**
     * @return string
     */
    public function getLogin(): string
    {
        return $this->login;
    }

    /**
     * @param string $login
     */
    public function setLogin(string $login): void
    {
        $this->login = $login;
    }

    /**
     * @return string
     */
    public function getPassword(): string
    {
        return $this->password;
    }

    /**
     * @param string $password
     */
    public function setPassword(string $password): void
    {
        $this->password = $password;
    }

    /**
     * @return string
     */
    public function getPhoneNumber(): string
    {
        return $this->phone_number;
    }

    /**
     * @param string $phone_number
     */
    public function setPhoneNumber(string $phone_number): void
    {
        $this->phone_number = $phone_number;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @param string $email
     */
    public function setEmail(string $email): void
    {
        $this->email = $email;
    }

    /**
     * @return array
     */
    public function getExtra(): array
    {
        return $this->extra;
    }

    /**
     * @param array $extra
     */
    public function setExtra(array $extra): void
    {
        $this->extra = $extra;
    }

    /**
     * @param array $data
     * @return static
     */
    public static function createFromArray(array $data) : self
    {
        $ob = new self();
        $ob->setLogin($data['login']);
        $ob->setPassword($data['password']);
        $ob->setEmail($data['email']);
        $ob->setPhoneNumber($data['phone_number']);

        if (isset($data['extra']))
            $ob->setExtra($data['extra']);

        return $ob;
    }

    /**
     * @return array
     */
    public function toArray(): array
    {
        return [
            'login'         => $this->getLogin(),
            'password'      => $this->getPassword(),
            'email'         => $this->getEmail(),
            'phone_number'  => $this->getPhoneNumber(),
            'extra'         => $this->getExtra(),
        ];
    }
}