<?php

namespace Astreya\WalletUtils\Dto;

class ProfileData
{
    protected string $account_level;

    protected array $persona_data;

    protected WalletStates $states;

    protected array $extra;

    /**
     * @return string
     */
    public function getAccountLevel(): string
    {
        return $this->account_level;
    }

    /**
     * @param string $account_level
     */
    public function setAccountLevel(string $account_level): void
    {
        $this->account_level = $account_level;
    }

    /**
     * @return array
     */
    public function getPersonaData(): array
    {
        return $this->persona_data;
    }

    /**
     * @param array $persona_data
     */
    public function setPersonaData(array $persona_data): void
    {
        $this->persona_data = $persona_data;
    }

    /**
     * @return WalletStates
     */
    public function getStates(): WalletStates
    {
        return $this->states;
    }

    /**
     * @param WalletStates $states
     */
    public function setStates(WalletStates $states): void
    {
        $this->states = $states;
    }

    /**
     * @return array
     */
    public function getExtra(): array
    {
        return $this->extra;
    }

    /**
     * @param array $extra
     */
    public function setExtra(array $extra): void
    {
        $this->extra = $extra;
    }

    public static function createFromArray(array $data): self
    {
        $ob = new self();
        $ob->setAccountLevel($data['account_level']);
        $ob->setPersonaData($data['persona_data'] ?? []);
        $ob->setStates(WalletStates::createFromArray($data['states'] ?? []));
        $ob->setExtra($data['extra'] ?? []);

        return $ob;
    }

    public function toArray() : array
    {
        return [
            'account_level' => $this->getAccountLevel(),
            'persona_data'  => $this->getPersonaData(),
            'states'        => $this->states->toArray(),
            'extra'         => $this->getExtra()
        ];
    }
}