<?php

namespace Astreya\TaskSystem\Tests\Unit\Services;

use Astreya\TaskSystem\Models\QueuedTask;
use Astreya\TaskSystem\Services\TaskService;
use Astreya\TaskSystem\Tests\IntegrationTest;
use Astreya\WalletUtils\Dto\QueuedTaskData;
use Closure;
use Generator;
use Illuminate\Support\Facades\Cache;

class TaskServiceTest extends IntegrationTest
{
    protected TaskService $taskService;

    const DEFAULT_TASK_TYPE = QueuedTaskData::TYPE_FETCH_BALANCE;

    /**
     * @throws \Throwable
     */
    protected function setUp(): void
    {
        parent::setUp();

        $this->taskService = $this->app->get(TaskService::class);
    }

    public function dataProvider_for_findExistTask(): Generator
    {
        yield 'should_return_null' => [function(){
            return [null];
        }];

        yield 'should_return_task' => [function(){
            $task = QueuedTask::factory()->create();
            // Что бы корректно сравнивало модели
            $task = QueuedTask::find($task->getKey());
            Cache::set('some_key', $task->getKey());
            return [$task];
        }];
    }

    /**
     * @dataProvider dataProvider_for_findExistTask
     * @param \Closure $fn
     * @return void
     */
    public function testFindExistTask(Closure $fn): void
    {
        [$expectedResult] = $fn();

        $task = $this->taskService->findExistTask('some_key');
        $this->assertEquals($expectedResult, $task);
    }

    public function testInitQueuedTask(): void
    {
        $task = $this->taskService->initQueuedTask(self::DEFAULT_TASK_TYPE, []);

        $this->assertEquals(QueuedTaskData::STATE_IN_QUEUE, $task->state);
        $this->assertEquals(self::DEFAULT_TASK_TYPE, $task->type);
    }

    public function testGetTaskForProcess(): void
    {
        $this->taskService->initQueuedTask(self::DEFAULT_TASK_TYPE, []);
        $tasksForProcess = $this->taskService->getTaskForProcess(self::DEFAULT_TASK_TYPE);

        $this->assertCount(1, $tasksForProcess);
    }
}