<?php

namespace Astreya\TaskSystem\Tests\Unit\Processors\Preparation;

use Astreya\TaskSystem\Processors\Preparation\AbstractPreparationProcessor;
use Astreya\TaskSystem\Processors\Preparation\DummyPreparationProcessor;
use Astreya\TaskSystem\Tests\Unit\Processors\ProcessorTestCase;
use Astreya\WalletUtils\Dto\QueuedTaskData;
use PHPUnit\Framework\TestCase;

class AbstractPreparationProcessorTest extends ProcessorTestCase
{
    protected function setUp(): void
    {
        parent::setUp();

        $this->task = $this->taskService->initPreparationTask([
            'wallet'    => $this->buildWalletData()->toArray(),
            'proxy'     => $this->faker->url()
        ]);
    }

    public function testRun()
    {
        $processor = new DummyPreparationProcessor($this->task);
        $processor->run();

        $this->assertEquals(QueuedTaskData::STATE_DONE, $this->task->state);
    }
}
