<?php

namespace Astreya\TaskSystem\Tests\Unit\Processors\FetchBalance;

use Astreya\TaskSystem\Processors\FetchBalance\DummyFetchBalanceProcessor;
use Astreya\TaskSystem\Tests\Unit\Processors\ProcessorTestCase;
use Astreya\WalletUtils\Dto\QueuedTaskData;

class AbstractFetchBalanceProcessorTest extends ProcessorTestCase
{
    /**
     * @return void
     * @throws \Throwable
     */
    protected function setUp(): void
    {
        parent::setUp();

        $this->task = $this->taskService->initFetchBalanceTask([
            'wallet'    => $this->buildWalletData()->toArray(),
            'proxy'     => $this->faker->url()
        ]);
    }

    public function testRun()
    {
        $processor = new DummyFetchBalanceProcessor($this->task);
        $processor->run();

        $this->assertEquals(QueuedTaskData::STATE_DONE, $this->task->state);
    }
}
