<?php

namespace Astreya\TaskSystem\Services;

use Astreya\TaskSystem\Models\QueuedTask;
use Astreya\WalletUtils\Dto\QueuedTaskData;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Str;

class TaskService
{
    /**
     * @param string $type
     * @param array $context
     * @return \Astreya\TaskSystem\Models\QueuedTask
     */
    public function initQueuedTask(string $type, array $context) : QueuedTask
    {
        //$walletData = WalletData::createFromArray($context['wallet']);
        //$key = "{$type}:{$walletData->getLogin()}";

        /* Защита от дублей. Лучше пока не усложнять механику и отключить этот функционал
        $task = $this->findExistTask("{$type}:{$walletData->getLogin()}");
        if ($task)
            return $task;
        */

        $task = QueuedTask::create([
            'state' => QueuedTaskData::STATE_IN_QUEUE,
            'type' => $type,
            'id' => Str::uuid()->toString(),
            'context' => $context,
        ]);

        //Cache::set($key, $task->id, 600);

        return $task;
    }

    /**
     * Формирование задачи на забор баланса
     * @param array $context
     * @return \Astreya\TaskSystem\Models\QueuedTask
     */
    public function initFetchBalanceTask(array $context): QueuedTask
    {
        return $this->initQueuedTask(QueuedTaskData::TYPE_FETCH_BALANCE, $context);
    }

    /**
     * Формирование задачи на забор платежей
     * @param array $context
     * @return \Astreya\TaskSystem\Models\QueuedTask
     */
    public function initFetchPaymentsTask(array $context): QueuedTask
    {
        return $this->initQueuedTask(QueuedTaskData::TYPE_FETCH_PAYMENTS, $context);
    }

    /**
     * Формирование задачи на забор профиля
     * @param array $context
     * @return \Astreya\TaskSystem\Models\QueuedTask
     */
    public function initFetchProfileTask(array $context): QueuedTask
    {
        return $this->initQueuedTask(QueuedTaskData::TYPE_FETCH_PROFILE, $context);
    }

    /**
     * Формирование задачи на регистрацию
     * @param array $context
     * @return \Astreya\TaskSystem\Models\QueuedTask
     */
    public function initSignUpTask(array $context): QueuedTask
    {
        return $this->initQueuedTask(QueuedTaskData::TYPE_SIGN_UP, $context);
    }

    /**
     * Формирование задачи на авторизацию
     * @param array $context
     * @return \Astreya\TaskSystem\Models\QueuedTask
     */
    public function initSignInTask(array $context): QueuedTask
    {
        return $this->initQueuedTask(QueuedTaskData::TYPE_SIGN_IN, $context);
    }

    /**
     * Формирование задачи на подготовку
     * @param array $context
     * @return \Astreya\TaskSystem\Models\QueuedTask
     */
    public function initPreparationTask(array $context): QueuedTask
    {
        return $this->initQueuedTask(QueuedTaskData::TYPE_PREPARATION, $context);
    }

    /**
     * Формирование задачи на создание платежа
     * @param array $context
     * @return \Astreya\TaskSystem\Models\QueuedTask
     */
    public function initCreatePaymentTask(array $context): QueuedTask
    {
        return $this->initQueuedTask(QueuedTaskData::TYPE_CREATE_PAYMENT, $context);
    }

    /**
     * Поиск существующей задачи по ключу
     * @param string $key
     * @return \Astreya\TaskSystem\Models\QueuedTask|null
     */
    public function findExistTask(string $key): ?QueuedTask
    {
        $id = Cache::get($key);

        if ($id === null)
            return null;

        return QueuedTask::find($id);
    }

    public function getTaskForProcess(string $type) : Collection
    {
        return QueuedTask::whereIn('state', [QueuedTaskData::STATE_IN_QUEUE, QueuedTaskData::STATE_IN_PROGRESS])
            ->where('type', '=', $type)->get();
    }
}