<?php

namespace Astreya\TaskSystem\Processors\FetchProfile;

use Astreya\TaskSystem\Processors\BaseTaskProcessor;
use Astreya\WalletUtils\Dto\QueuedTaskData;
use Sentry\State\Scope;
use function Sentry\withScope;

abstract class AbstractFetchProfileProcessor extends BaseTaskProcessor
{
    protected string $proxy;

    public function run(): void
    {
        $this->proxy = $this->currentTask->context['proxy'] ?? '';
        withScope(function(Scope $scope){
            $scope->setTags([
                'type'      => QueuedTaskData::TYPE_FETCH_PROFILE,
                'wallet'    => $this->currentTask->getWalletData()->getLogin(),
                'proxy'     => $this->proxy,
            ]);
        });

        parent::run();

        withScope(function(Scope $scope){
            $scope->setContext('result', $this->currentTask->result);
        });
    }
}
