<?php

use Astreya\TaskSystem\Http\Controllers\Api\V1\TaskController;
use Astreya\TaskSystem\Http\Middleware\SentryForTask;
use Astreya\TaskSystem\Models\QueuedTask;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::model('queued_task', QueuedTask::class);

Route::name('v1.')->prefix("v1")->group(function () {
    Route::name('task.')->prefix("task")->middleware(config('astreya-tasks.http_middlewares'))->group(function () {
        Route::get('{queued_task}', [TaskController::class, 'view'])->name('view');
        Route::post('', [TaskController::class, 'store'])->name('store');
        Route::post('{queued_task}/process', [TaskController::class, 'process'])->name('process');
        Route::post('{queued_task}/reject', [TaskController::class, 'reject'])->name('reject');
    });
});


