<?php

use Astreya\TaskSystem\Http\Middleware\SentryForTask;
use Astreya\TaskSystem\Processors\FetchBalance\DummyFetchBalanceProcessor;
use Astreya\TaskSystem\Processors\FetchPayments\DummyFetchPaymentsProcessor;
use Astreya\TaskSystem\Processors\FetchProfile\DummyFetchProfileProcessor;
use Astreya\TaskSystem\Processors\Payment\DummyPaymentProcessor;
use Astreya\TaskSystem\Processors\Preparation\DummyPreparationProcessor;
use Astreya\TaskSystem\Processors\SignIn\DummySignInProcessor;
use Astreya\TaskSystem\Processors\SignUp\DummySignUpProcessor;
use Astreya\WalletUtils\Dto\QueuedTaskData;

return [
    /**
     * Установленные по типам процессоры для задач
     */
    'task_processors' => [
        QueuedTaskData::TYPE_CREATE_PAYMENT => DummyPaymentProcessor::class,
        QueuedTaskData::TYPE_SIGN_UP        => DummySignUpProcessor::class,
        QueuedTaskData::TYPE_SIGN_IN        => DummySignInProcessor::class,
        QueuedTaskData::TYPE_PREPARATION    => DummyPreparationProcessor::class,
        QueuedTaskData::TYPE_FETCH_PROFILE  => DummyFetchProfileProcessor::class,
        QueuedTaskData::TYPE_FETCH_PAYMENTS => DummyFetchPaymentsProcessor::class,
        QueuedTaskData::TYPE_FETCH_BALANCE  => DummyFetchBalanceProcessor::class
    ],

    /**
     * Список мидлварей для HTTP
     */
    'http_middlewares' => [
        SentryForTask::class
    ]
];