<?php

namespace Astreya\TaskSystem\Tests\Unit\Processors\SignUp;

use Astreya\TaskSystem\Processors\SignUp\AbstractSignUpProcessor;
use Astreya\TaskSystem\Processors\SignUp\DummySignUpProcessor;
use Astreya\TaskSystem\Tests\Unit\Processors\ProcessorTestCase;
use Astreya\WalletUtils\Dto\QueuedTaskData;
use PHPUnit\Framework\TestCase;

class AbstractSignUpProcessorTest extends ProcessorTestCase
{
    protected function setUp(): void
    {
        parent::setUp();

        $this->task = $this->taskService->initSignUpTask([
            'wallet'    => $this->buildWalletData()->toArray(),
            'proxy'     => $this->faker->url()
        ]);
    }

    public function testRun()
    {
        $sentryTransaction = $this->startSentryTransaction('process_task');

        $processor = new DummySignUpProcessor($this->task);
        $processor->run();

        $this->assertEquals(QueuedTaskData::STATE_DONE, $this->task->state);

        $tags = $sentryTransaction->getTags();

        $this->assertArrayHasKey('type', $tags);
        $this->assertArrayHasKey('wallet', $tags);
        $this->assertArrayHasKey('proxy', $tags);
    }
}
