<?php

namespace Astreya\TaskSystem\Tests\Unit\Processors\SignIn;

use Astreya\TaskSystem\Processors\SignIn\AbstractSignInProcessor;
use Astreya\TaskSystem\Processors\SignIn\DummySignInProcessor;
use Astreya\TaskSystem\Tests\Unit\Processors\ProcessorTestCase;
use Astreya\WalletUtils\Dto\QueuedTaskData;
use PHPUnit\Framework\TestCase;

class AbstractSignInProcessorTest extends ProcessorTestCase
{
    protected function setUp(): void
    {
        parent::setUp();

        $this->task = $this->taskService->initSignInTask([
            'wallet'    => $this->buildWalletData()->toArray(),
            'proxy'     => $this->faker->url()
        ]);
    }

    public function testRun()
    {
        $sentryTransaction = $this->startSentryTransaction('process_task');

        $processor = new DummySignInProcessor($this->task);
        $processor->run();

        $this->assertEquals(QueuedTaskData::STATE_DONE, $this->task->state);

        $tags = $sentryTransaction->getTags();

        $this->assertArrayHasKey('type', $tags);
        $this->assertArrayHasKey('wallet', $tags);
        $this->assertArrayHasKey('proxy', $tags);
    }
}
