<?php

namespace Astreya\TaskSystem\Tests\Unit\Models;

use Astreya\TaskSystem\Models\QueuedTask;
use Astreya\TaskSystem\Tests\IntegrationTest;
use Astreya\WalletUtils\Dto\QueuedTaskData;
use Astreya\WalletUtils\Dto\WalletData;

class QueuedTaskTest extends IntegrationTest
{
    const DEFAULT_TASK_TYPE = QueuedTaskData::TYPE_FETCH_BALANCE;

    protected QueuedTask $task;

    protected function setUp(): void
    {
        parent::setUp();

        $this->task = QueuedTask::factory()->create([
            'type'      => self::DEFAULT_TASK_TYPE,
            'context' => [
                'proxy'     => $this->faker->url,
                'wallet'    => $this->buildWalletData()->toArray()
            ]
        ]);
    }

    public function testGetWalletData()
    {
        $actualData = $this->task->getWalletData();
        $this->assertInstanceOf(WalletData::class, $actualData);
    }

    public function testGetProxy()
    {
        $actualData = $this->task->getProxy();
        $this->assertNotEmpty($actualData);
    }

    public function testToTaskData()
    {
        $actualData = $this->task->toTaskData();
        $this->assertInstanceOf(QueuedTaskData::class, $actualData);
    }
}
