<?php


namespace Astreya\TaskSystem\Processors\Payment;

use Astreya\TaskSystem\Processors\BaseTaskProcessor;
use Astreya\WalletUtils\Dto\PaymentData;
use Astreya\WalletUtils\Dto\QueuedTaskData;
use Sentry\State\Scope;
use function Sentry\withScope;

abstract class AbstractPaymentProcessor extends BaseTaskProcessor
{
    protected PaymentData $paymentData;

    protected string $proxy;

    public function run(): void
    {
        $this->proxy = $this->currentTask->context['proxy'] ?? '';
        $this->paymentData = PaymentData::createFromArray($this->currentTask->context['payment']);

        withScope(function(Scope $scope){
            if ($scope->getTransaction()) {
                $scope->getTransaction()->setTags([
                    'type'      => QueuedTaskData::TYPE_CREATE_PAYMENT,
                    'wallet'    => $this->currentTask->getWalletData()->getLogin(),
                    'proxy'     => $this->proxy,
                ]);
            }
        });

        parent::run();

        withScope(function(Scope $scope){
            $scope->setContext('result', $this->currentTask->result);
        });
    }
}
