<?php


namespace Astreya\TaskSystem\Jobs\Middleware;

use Astreya\TaskSystem\Traits\WithSentry;
use Sentry\Tracing\SpanStatus;
use Sentry\Tracing\TransactionContext;
use Throwable;
use function Sentry\captureException;

class WithSentryTransaction
{
    use WithSentry;

    private string $transaction_name;

    public function __construct(string $transaction_name)
    {
        $this->transaction_name = $transaction_name;
    }

    /**
     * Process the job.
     *
     * @param  mixed  $job
     * @param callable $next
     * @return mixed
     */
    public function handle(mixed $job, callable $next): mixed
    {
        // Не вызываем функционал sentry, если мы в процессе тестирования
        //if (app()->environment('testing'))
        //    return $next($job);

        $tc = new TransactionContext();
        $tc->setName($this->transaction_name);
        $tc->setOp('app.job');

        $transaction = $this->getSentry()->startTransaction($tc);
        $this->getSentry()->setSpan($transaction);
        try {
            $cb = $next($job);
            $transaction = $this->getSentry()->getTransaction();
            if ($transaction && $transaction->getStatus() === null)
                $transaction->setStatus(SpanStatus::ok());

            return $cb;
        } catch (Throwable $exception) {
            $transaction = $this->getSentry()->getTransaction();
            if ($transaction && $transaction->getStatus() === null)
                $transaction->setStatus(SpanStatus::unknownError());

            // throw $exception;
            captureException($exception);
        } finally {
            $transaction = $this->getSentry()->getTransaction();
            if ($transaction)
                $transaction->finish();
        }

        return null;
    }
}
