<?php

namespace Astreya\TaskSystem\Tests\Feature\Processors;

use Astreya\TaskSystem\Models\QueuedTask;
use Astreya\TaskSystem\Processors\BaseTaskProcessor;
use Astreya\TaskSystem\Processors\FetchBalance\DummyFetchBalanceProcessor;
use Astreya\TaskSystem\Tests\IntegrationTest;
use Astreya\WalletUtils\Dto\QueuedTaskData;
use LogicException;
use Mockery\Mock;
use Mockery\MockInterface;
use function Illuminate\Events\queueable;

class BaseTaskProcessorTest extends IntegrationTest
{
    const DEFAULT_TASK_TYPE = QueuedTaskData::TYPE_FETCH_BALANCE;

    protected QueuedTask $task;

    /**
     * @var mixed|BaseTaskProcessor
     */
    protected mixed $processor;

    protected function setUp(): void
    {
        parent::setUp();

        $this->task = QueuedTask::factory()->create([
            'type' => self::DEFAULT_TASK_TYPE,
            'context' => [
                'wallet' => $this->buildWalletData()->toArray()
            ]
        ]);

        $this->processor = $this->partialMock(DummyFetchBalanceProcessor::class, function (MockInterface $mock) {
            $mock->shouldAllowMockingProtectedMethods();
            $mock->shouldReceive('begin_step')->andThrow(LogicException::class);
        });

        $this->processor->setTask($this->task);
    }

    public function test_it_should_failed_task() {
        $this->processor->run();
        $this->assertEquals(QueuedTaskData::STATE_FAILED, $this->task->state);
    }
}
