<?php


namespace Astreya\TaskSystem\Processors\Payment;

use Astreya\WalletUtils\Dto\PaymentData;
use Astreya\WalletUtils\Dto\QueuedTaskData;

class DummyPaymentProcessor extends AbstractPaymentProcessor
{
    protected function begin_step(): void
    {
        $this->setStep(self::DEFAULT_STEP);

        $this->currentTask->state = QueuedTaskData::STATE_DONE;
        $this->paymentData->setTransactionId(strval(time()));
        $this->paymentData->setState(PaymentData::STATE_SUCCESS);

        $this->currentTask->result = [
            'wallet' =>  $this->currentTask->getWalletData()
        ];
    }
}
