<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Astreya\WalletUtils\Dto\QueuedTaskData;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::table('queued_tasks', function (Blueprint $table) {
            $table->string('unique_id')
                ->comment('Уникальный ID задачи')
                ->after('id')
                ->nullable()
                ->unique();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::table('queued_tasks', function (Blueprint $table) {
            $table->dropColumn('unique_id');
        });
    }
};
