<?php

namespace Database\Factories;

use Astreya\TaskSystem\Models\QueuedTask;
use Astreya\WalletUtils\Dto\QueuedTaskData;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class QueuedTaskFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = QueuedTask::class;
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition(): array
    {
        return [
            'state' => $this->faker->randomElement(QueuedTaskData::STATES),
            'type' => $this->faker->randomElement(QueuedTaskData::TYPES),
            'id' => Str::uuid()->toString(),
            'context' => $this->faker->randomElements,
        ];
    }
}
