<?php

namespace Astreya\TaskSystem\Tests\Feature\Http\Controllers\Api\V1;

use Astreya\TaskSystem\Models\QueuedTask;
use Astreya\TaskSystem\Tests\IntegrationTest;
use Astreya\WalletUtils\Dto\QueuedTaskData;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;

class TaskControllerTest extends IntegrationTest
{
    use WithFaker, RefreshDatabase;

    public function test_it_create_task(): void
    {
        /** @var QueuedTask $queued_task */
        $queued_task = QueuedTask::factory()->make();

        $this
            ->postJson(route('v1.task.store', [
                'type'      => $queued_task->type,
                'context'   => $queued_task->context
            ]))
            ->assertOk()
            ->assertJsonStructure([
                "result",
                "data" => [
                    'id',
                    'type',
                    'state',
                    'context'
                ]
            ]);
    }

    /**
     * Тест на забор информации по задаче
     *
     * @return void
     */
    public function test_it_get_task_details(): void
    {
        $this
            ->getJson(route('v1.task.view', [
                'queued_task' => QueuedTask::factory()->create()
            ]))
            ->assertOk()
            ->assertJsonStructure([
                "result",
                "data"
            ]);
    }

    /**
     * Тест на обработку задачи
     *
     * @return void
     */
    public function test_it_process_task(): void
    {
        $this
            ->postJson(route('v1.task.process', [
                'queued_task' => QueuedTask::factory()->create([
                    'type'  => QueuedTaskData::TYPE_FETCH_BALANCE,
                    'state' => QueuedTaskData::STATE_IN_PROGRESS,
                    'context' => [
                        'wallet' => $this->buildWalletData()->toArray(),
                    ]
                ])
            ]))
            ->assertOk()
            ->assertJsonStructure([
                "result",
                "data"
            ])->assertJsonFragment(
                [
                    'state' => QueuedTaskData::STATE_DONE
                ]
            );
    }

    /**
     * Тест на отмену задачи
     *
     * @return void
     */
    public function test_it_reject_task(): void
    {
        $this
            ->postJson(route('v1.task.reject', [
                'queued_task' => QueuedTask::factory()->create([
                    'type'  => QueuedTaskData::TYPE_FETCH_BALANCE,
                    'state' => QueuedTaskData::STATE_IN_PROGRESS,
                    'context' => [
                        'wallet' => $this->buildWalletData()->toArray(),
                    ]
                ])
            ]))
            ->assertOk()
            ->assertJsonStructure([
                "result",
                "data"
            ])->assertJsonFragment(
                [
                    'state' => QueuedTaskData::STATE_REJECTED
                ]
            );
    }
}
