<?php

namespace Astreya\TaskSystem\Providers;

use Astreya\TaskSystem\Models\QueuedTask;
use Astreya\TaskSystem\Services\TaskService;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;

class TaskServiceProvider extends ServiceProvider
{
    public function register()
    {
        $this->app->singleton(TaskService::class, function () {
            return new TaskService();
        });
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot(): void
    {
        //
        $this->registerResources();
        $this->registerPublishing();
    }

    /**
     * Register the package's publishable resources.
     *
     * @return void
     */
    protected function registerPublishing(): void
    {
        $this->publishes([
            __DIR__ . '/../../config/astreya-tasks.php' => config_path('astreya-tasks.php'),
        ], 'astreya-tasks');
    }

    /**
     * Register the package resources such as routes, templates, etc.
     *
     * @return void
     */
    protected function registerResources(): void
    {
        if (! $this->app->configurationIsCached()) {
            $this->mergeConfigFrom(__DIR__ . '/../../config/astreya-tasks.php', 'astreya-tasks');
        }

        Route::model('queued_task', QueuedTask::class);
        Route::prefix('api')
            ->middleware('api')
            ->group(__DIR__ . '/../../routes/api.php');

        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
    }
}