<?php

namespace Astreya\TaskSystem\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;

class CreateTaskRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'type'      => 'required',
            'context'   => 'required|array'
        ];
    }

    public function getTaskType(): string
    {
        return $this->get('type');
    }

    public function getTaskContext(): array
    {
        return (array)$this->get('context');
    }
}