<?php

namespace Astreya\TaskSystem\Models;

use Database\Factories\QueuedTaskFactory;
use Astreya\WalletUtils\Dto\QueuedTaskData;
use Astreya\WalletUtils\Dto\WalletData;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * App\Models\QueuedTask
 *
 * @property string $id
 * @property string $unique_id Уникальный ID задачи
 * @property string $type
 * @property string $state
 * @property array $context
 * @property array $result
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static Builder|QueuedTask newModelQuery()
 * @method static Builder|QueuedTask newQuery()
 * @method static Builder|QueuedTask query()
 * @mixin \Eloquent
 */
class QueuedTask extends Model
{
    use HasFactory;

    public $incrementing = false;

    protected $fillable = [
        'id', 'unique_id', 'type', 'state', 'name', 'context', 'created_at', 'updated_at'
    ];

    protected $attributes = [
        'context' => '{}',
        'result' => '{}',
    ];

    protected $casts = [
        'context' => 'array',
        'result'  => 'array',
    ];

    public function toTaskData(): QueuedTaskData
    {
        return QueuedTaskData::createFromArray($this->toArray());
    }

    public function getWalletData(): WalletData
    {
        return WalletData::createFromArray($this->context['wallet']);
    }

    public function getProxy(): string
    {
        return $this->context['proxy'];
    }

    /**
     * Create a new factory instance for the model.
     *
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    protected static function newFactory(): Factory
    {
        return QueuedTaskFactory::new();
    }
}
